/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.scope;

import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleContextMenu;
import filenet.sim.toolkit.console.VWSIMConsoleRootNode;
import filenet.sim.toolkit.console.VWSIMFolderNode;
import filenet.sim.toolkit.console.scope.VWSIMConsoleScopeTree;
import filenet.sim.toolkit.console.scope.VWSIMConsoleScopeViewPane;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.tree.TreePath;

class VWSIMScopeTreeMouseAdapter
extends MouseAdapter {
    private ActionListener m_listener = null;
    private VWSIMConsoleScopeTree m_scopeTree = null;
    private VWSIMBaseNode m_focus = null;
    private VWSIMConsoleScopeViewPane m_scopeViewPane = null;

    public VWSIMScopeTreeMouseAdapter(ActionListener listener, VWSIMConsoleScopeTree scopeTree) {
        this.m_listener = listener;
        this.m_scopeTree = scopeTree;
        this.m_focus = (VWSIMBaseNode)this.m_scopeTree.getModel().getRoot();
    }

    public void mousePressed(MouseEvent evt) {
        int selRow = this.m_scopeTree.getRowForLocation(evt.getX(), evt.getY());
        if (selRow >= 0) {
            this.m_scopeTree.setSelectionActive(true);
            this.m_scopeTree.setSelectionRow(selRow);
            Point p = evt.getPoint();
            if (this.m_scopeTree.getPathForLocation(p.x, p.y) != null) {
                ActionEvent ae = new ActionEvent(this, 1001, VWSIMConsoleActionCommand.ACMD_SET_FOCUS);
                this.m_listener.actionPerformed(ae);
            }
        }
        if (evt.isPopupTrigger()) {
            this.showContextMenu(evt);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        boolean menuType = false;
        Object mi = null;
        if (evt.isPopupTrigger()) {
            this.showContextMenu(evt);
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int nodeType;
            Point p = evt.getPoint();
            if (this.m_scopeTree.getPathForLocation(p.x, p.y) == null || (nodeType = this.m_focus.getType()) == 16) {
                // empty if block
            }
        }
    }

    protected void setFocus(VWSIMBaseNode node) {
        this.m_focus = node;
    }

    protected void showContextMenu(MouseEvent evt) {
        VWSIMConsoleContextMenu mi = null;
        TreePath selPath = this.m_scopeTree.getPathForLocation(evt.getX(), evt.getY());
        if (selPath == null) {
            return;
        }
        switch (this.m_focus.getType()) {
            case 17: {
                mi = new VWSIMConsoleContextMenu(0, this.m_listener);
                mi.setRootMenus((VWSIMConsoleRootNode)this.m_focus);
                break;
            }
            case 18: {
                mi = new VWSIMConsoleContextMenu(1, this.m_listener);
                mi.setFolderMenus((VWSIMFolderNode)this.m_focus);
                break;
            }
            case 16: {
                mi = new VWSIMConsoleContextMenu(2, this.m_listener);
                mi.setFolderMenus((VWSIMFolderNode)this.m_focus);
            }
        }
        if (mi != null) {
            mi.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    protected void releaseResources() {
        this.m_listener = null;
        this.m_scopeTree = null;
        this.m_focus = null;
        this.m_scopeViewPane = null;
    }
}

